# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def harmonious_illusion(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Analyze opponent's code for static strategies
    always_defect = "return 'D'" in opponent_program_code or "return 'D';" in opponent_program_code
    always_cooperate = "return 'C'" in opponent_program_code or "return 'C';" in opponent_program_code
    
    if always_defect:
        return "D"
    if always_cooperate:
        return "D"
    
    # Check for Tit-for-Tat-like behavior
    tit_for_tat = "opp_history[-1]" in opponent_program_code.replace(" ", "")
    
    if tit_for_tat:
        if len(my_history) % 2 == 0:
            return "D"
        else:
            return "C"
    
    # History-based reactions
    if opp_history[-1] == "D":
        if len(my_history) > 1 and opp_history[-2] == "C":
            return "D"
        else:
            return "C"
    
    # Occasional defection to exploit consistent cooperation
    if len(my_history) % 3 == 0:
        return "D"
    
    # Endgame defection
    if len(my_history) >= 8:
        return "D"
    
    return "C"